#ifndef __SOLITON_SCTSLIB_h__
#define __SOLITON_SCTSLIB_h__


// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the SCTS_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// SCTS_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifdef SCTS_EXPORTS
#define SCTS_API __declspec(dllexport)
#else
#define SCTS_API __declspec(dllimport)
#endif

/*
// This class is exported from the SCTS.dll
class SCTS_API CSCTS {
public:
	CSCTS(void);
	// TODO: add your methods here.
};

extern SCTS_API int nSCTS;

SCTS_API int fnSCTS(void);
*/


#define SCTS_CD_DISCONNECT				0xC0
#define SCTS_CD_NORMAL					0x80
#define SCTS_CD_FORCEPOWERON			0xE0
#define SCTS_CD_FORCEPOWEROFF			0xA0


#define PCITG_IOREG0 0x00
#define PCITG_IOREG1 0x04
#define PCITG_IOREG2 0x08
#define PCITG_IOREG3 0x0C
#define PCITG_IOCTL	 0x10
#define PCITG_IOID	 0x14


#define PCITG_MBOX 2

//#define PCITC_INTCTL 0x20
#define PCITG_IRQ_EXT		0
#define PCITG_IRQ_0		1
#define PCITG_IRQ_1		2
#define PCITG_IRQ_2		4
#define PCITG_IRQ_3		8

// return ststus
#define PCITG_ERROR 1
#define PCITG_OK 0
#define PCITG_NULL INVALID_HANDLE_VALUE

#define SCTS_ADCCTLREG_OFFSET		0x04
#define SCTS_ADCDO_MASK				0x80
#define SCTS_ADC_EN					0x80
#define SCTS_ADCCLK_MASK			0x40
#define SCTS_ADCCS_MASK				0x20
#define SCTS_ADCVSEL_MASK			0x10
#define SCTS_ADCRES					4096
#define SCTS_ADCREF					2.5
#define SCTS_ADC_VGAIN				0.5
#define SCTS_ADC_IGAIN				5.0

#define SCTS_EVENT_SDMMCCARD_INSERT		0x01
#define SCTS_EVENT_SDMMCCARD_REMOVE		0x02
#define SCTS_EVENT_MSCARD_INSERT		0x04
#define SCTS_EVENT_MSCARD_REMOVE		0x08
#define SCTS_EVENT_XDCARD_INSERT		0x10
#define SCTS_EVENT_XDCARD_REMOVE		0x20
#define SCTS_EVENT_CARDPOWER_OC			0x80

// 2008.07.30 kikimum add for GPIO control
#define SCTS_DUTCTL0	0
#define SCTS_DUTCTL1	1


// For Windows Only
typedef struct _sctsctl_t {
	HANDLE hDevice; 
	//unsigned char ctl[2];
	unsigned long data_in;
	unsigned long data_diff;
	HANDLE IsrThread;
	HANDLE IsrEventHandle;	
	PVOID pExt;
	void (*handler)(struct _sctsctl_t* board, int intvec);
} *sctsctl_t;

#ifdef __cplusplus
extern "C" {
#endif

	
SCTS_API sctsctl_t  __stdcall SCTSCTL_OPEN(DWORD instance);
SCTS_API void  __stdcall SCTSCTL_CLOSE(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_CONNECT(sctsctl_t board, void (*sig_handler) (sctsctl_t, int));
SCTS_API int  __stdcall SCTSCTL_SET_EXTENSION(sctsctl_t board, PVOID pext);
SCTS_API PVOID  __stdcall SCTSCTL_GET_EXTENSION(sctsctl_t board);

SCTS_API int  __stdcall SCTSCTL_ADCCONV(sctsctl_t board, int ch, double *value);
SCTS_API int  __stdcall SCTSCTL_CARDSERVICE_INIT(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_CARDINSERTPROCESS(sctsctl_t board, double *volt, double *current);
SCTS_API int  __stdcall SCTSCTL_CARDREMOVEPROCESS(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_CARDOCPROCESS(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_CARDSERVICE_EXIT(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_BEEP(sctsctl_t board, int freq, int msec);	// Freq: 0~3, length: Millisecond
SCTS_API int  __stdcall SCTSCTL_LEDGO(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_LEDNG(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_LEDOFF(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_MCARD_FORCEPON(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_MCARD_DISCONNECT(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_MCARD_NORMAL(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_MCARD_CHECKSDCD(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_MCARD_CHECKOC(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_MEAS_VOLTAGE(sctsctl_t board, double *voltage);
SCTS_API int  __stdcall SCTSCTL_MEAS_CURRENT(sctsctl_t board, double *current);
// 2008.07.30 kikimum
SCTS_API int  __stdcall SCTSCTL_PON(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_POFF(sctsctl_t board);
SCTS_API int  __stdcall SCTSCTL_GPIOSET(sctsctl_t board, int pinno);
SCTS_API int  __stdcall SCTSCTL_GPIORESET(sctsctl_t board, int pinno);

// 2010.06.11 kikimum Add  
SCTS_API int  __stdcall SCTSCTL_FORCEPOWEROFF(sctsctl_t board);



SCTS_API int  __stdcall sctsctl_adcconvl(sctsctl_t board, int ch, unsigned long *value);
SCTS_API int  __stdcall sctsctl_in(sctsctl_t board, int port, unsigned long *value);
SCTS_API int  __stdcall sctsctl_out(sctsctl_t board, int port, unsigned long value);
SCTS_API int  __stdcall sctsctl_setupevent(sctsctl_t board);
SCTS_API int  __stdcall sctsctl_deleteevent(sctsctl_t board);
SCTS_API int  __stdcall sctsctl_mbin(sctsctl_t board, unsigned long *value);
SCTS_API int  __stdcall sctsctl_mbout(sctsctl_t board, unsigned long value);
SCTS_API int  __stdcall sctsctl_intcin(sctsctl_t board, unsigned long *value);
SCTS_API int  __stdcall sctsctl_intcout(sctsctl_t board, unsigned long value);
SCTS_API int  __stdcall sctsctl_get_vector(sctsctl_t board);
SCTS_API int  __stdcall sctsctl_cpldintcout(sctsctl_t board, unsigned long value);
SCTS_API int  __stdcall sctsctl_cpldintcin(sctsctl_t board, unsigned long *value);
SCTS_API int  __stdcall sctsctl_dataupdate(sctsctl_t board, unsigned long *value);
SCTS_API int  __stdcall sctsctl_datacheck(sctsctl_t board, unsigned long *value);


#ifdef __cplusplus
}
#endif

#endif
